
' Constants used in the help library

'////////////////////////////////////////////////////////////////////////

' Advanced settings descriptions
Public Const IHELP_ADVSET_APPPATHS_TITLE = "Application Paths"
Public Const IHELP_ADVSET_APPPATHS_TEXT = "<p>Use this advanced setting to specify the paths to your component's files and folders. When you run your setup, it will create the <span class='glossary' title='The registry key that Windows uses to find your application and its DLLs if their locations are not already in the system&rsquo;s path.'>App Paths</span> key for your component under the registry key HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\App Paths\.</p>"
Public Const IHELP_ADVSET_COMREGISTRATION_TITLE = "COM Registration"
Public Const IHELP_ADVSET_COMREGISTRATION_TEXT = "<!--<table align='right' cellpadding='0' cellspacing='0'><tr><td><img id='RegisterComServer' src='showmebutton.gif' title='Click here to launch a demo to illustrate this feature.' style='cursor:hand' onmousedown='RegisterComServer.src=""showmebuttondown.gif""' onmouseup='RegisterComServer.src=""showmebutton.gif""' onclick='JavaScript:DisplayDemo (""registercomserver"", IHELP_DEMOS_FEATURENAME_COMSERVER, true)'></td></tr></table>--><p>In the COM Registration explorer you can enter or modify registration information for the <span class='glossary' title='An executable file that exposes objects to other applications according to the Component Object Model specification.  The types of objects exposed by a COM server may include ActiveX controls, ActiveX documents, Automation objects, or MTS components.'>COM server</span> that you have set as your component's key file. The COM Registration advanced setting is intended to replace self-registration, which is a violation of <a href='IIDESetupBestPractices.htm'>Setup Best Practices</a>.</p><p>To add a new COM class, progID, version-independent progID, or type library, right-click on an item in the tree view. Click on the item to set the properties for the registration data.</p><p>The recommended way to specify file registration is to use the Component wizard and have it automatically extract the necessary information for you. Use the COM Registration explorer only if you need to make advanced modifications. </p>"
Public Const IHELP_ADVSET_CTRLSERVICE_TITLE = "Control NT Services"
Public Const IHELP_ADVSET_CTRLSERVICE_TEXT = "<!--<table align='right' cellpadding='0' cellspacing='0'><tr><td><img id='controlntservice' src='showmebutton.gif' title='Click here to launch a demo to illustrate this feature.' style='cursor:hand' onmousedown='controlntservice.src=""showmebuttondown.gif""' onmouseup='controlntservice.src=""showmebutton.gif""'></td></tr></table>--><p>This advanced setting allows you to control an NT service when the component is installed or uninstalled. Right-click on Control NT Services to specify the service you want to control. Then, click on the service to view its Service Name property. Enter the actual name of the service.</p><p>Next, right-click on the service to create a service event. Give the event any unique name you like. Finally, click on the event to set its properties and specify how you want to control the service during installation and uninstallation. </p>"
Public Const IHELP_ADVSET_FILETYPES_TITLE = "File Types"
Public Const IHELP_ADVSET_FILETYPES_TEXT = "<!--<table align='right' cellpadding='0' cellspacing='0'><tr><td><img id='FileTypes' src='showmebutton.gif' title='Click here to launch a demo to illustrate this feature.' style='cursor:hand' onmousedown='FileTypes.src=""showmebuttondown.gif""' onmouseup='FileTypes.src=""showmebutton.gif""'></td></tr></table>--><p>This advanced setting registers the following information about a file type on the target system when the component is installed or <span class='glossary' title='Advertising is a type of &lsquo;just-in-time&rsquo; installation in which the components are not immediately installed.'>advertised</span>: </p><ul>	<li><b>File Extensions</b>&nbsp;&nbsp;	You can associate file extensions (such as doc and txt) with the component's key file.</li><li><b>ProgIDs</b>&nbsp;&nbsp;	By setting the ProgID property in the extension, you can name a progID&mdash;for example, <i>txtfile</i>&mdash;that will contain the file type registration.</li>	<li><b>Verbs</b>&nbsp;&nbsp;&nbsp;	You can register command verbs (such as <u>O</u>pen and <u>P</u>rint) that appear in the <span class='glossary' title='The operating system displays a context menu for a registered file type when a user right-clicks on the file on the desktop or in Windows Explorer. Verbs are the first elements to appear in the context menu.'>context menu</span> for a file of the registered extension.</li>   <li><b>MIME Type</b>&nbsp;&nbsp;	You can register the multipurpose Internet mail extension (MIME) types, also known as media types or content types, for the component's key file.  You can also associate a MIME type with a class ID.</ul>"
Public Const IHELP_ADVSET_PUBCOMP_TITLE = "Publishing"
Public Const IHELP_ADVSET_PUBCOMP_TEXT = "<p>Use this advanced setting to publish your component. Publishing is a type of <span class='glossary' title='Advertising is one of the modes you can run your setup in. When you launch Msiexec.exe with the /j <package> option, the components are advertised on the end user&rsquo;s system, but not immediately installed.'>advertising</span> (&ldquo;just-in-time&rdquo; installation) in which no user-interface elements are created for the component during installation, but the component can be installed through the Add/Remove Programs applet of the Control Panel or when an installed component requests the published component from the installer. </p> "
Public Const NTSVC_SERVICE_TITLE = "Install NT Services"
Public Const NTSVC_SERVICE_DESCRIPTION = "<!--<table align='right' cellpadding='0' cellspacing='0'><tr><td><img id='installntservices' src='showmebutton.gif' title='Click here to launch a demo to illustrate this feature.' style='cursor:hand' onmousedown='installntservices.src=""showmebuttondown.gif""' onmouseup='installntservices.src=""showmebutton.gif""'></td></tr></table>--><p>If this component's key file contains one or more NT services, use the Install NT Services advanced setting to specify installation information for the services. </p><p>Right-click on Install NT Services to create a new service name. Right-click and select Rename to change the service's name. </p><p>Select the service to edit its properties. You must be familiar with the technical details of your service before you can set its properties.</p>"
Public Const ODBC_HELP_SETTINGS_TITLE = "ODBC Resources"
Public Const ODBC_HELP_SETTINGS_TEXT = "<p>This advanced setting allows you to modify the driver, data source name, or translator attributes that you created for this ODBC resource in the Component wizard.</p><p>You cannot add or remove an ODBC resource in this view.  You can only edit its attributes. You must run the Component wizard again to add a new ODBC resource, and you would have to delete the component altogether to remove the ODBC resource from your project. </p>"

Public Const IHELP_ADVSET_ODBCRES_SPECIAL = "<p>Note that you will not see the ODBC Resources advanced setting unless you have already specified an ODBC resource in the Component wizard.  In other words, you can only <i>edit</i> ODBC installation settings in this advanced setting.</p>"
Public Const IHELP_ADVSET_APPPATHS_MOINFO = "<p>For more information about this advanced setting, see <a href='IHelpAddAppPathsToComponent.htm'>Create an Application Paths Key</a>.</p>"
Public Const IHELP_ADVSET_COMREGISTRATION_MOINFO = "<p>For more information about this advanced setting, see <a href='IHelpAdvCOMRegistration.htm'>Register a COM Server</a>.</p>"
Public Const IHELP_ADVSET_CTRLSERVICE_MOINFO = "<p>For more information about this advanced setting, see <a href='IHelpAdvCtrlNTServ.htm'>Control NT Service</a>.</p>"
Public Const IHELP_ADVSET_FILETYPES_MOINFO = "<p>For more information about this advanced setting, see <a href='IHelpAdvFileTypes.htm'>Register File Types</a>.</p>"
Public Const IHELP_ADVSET_NTSERV_MOINFO = "<p>For more information about this advanced setting, see <a href='IHelpAdvNTServ.htm'>Install NT Services</a>.</p>"
Public Const IHELP_ADVSET_ODBCRES_MOINFO = "<p>For more information about this advanced setting, see <a href='IHelpAdvODBC.htm'>Install ODBC Resources</a>.</p>"
Public Const IHELP_ADVSET_PUBCOMP_MOINFO = "<p>For more information about this advanced setting, see <a href='IHelpPublishComponent.htm'>Specify Publishing Information</a>.</p>"

Public Const IHELP_VCWIZ_WELCOME_TITLE = " Welcome Panel"
Public Const IHELP_VCWIZ_WELCOME_TEXT = "<p>This panel gives you some introductory information about the Visual C++ Project Wizard.</p><p>Click Next to continue.</P>"

Public Const IHELP_VCWIZ_WORKSPACE_TITLE = " The Workspace Information Panel"
Public Const IHELP_VCWIZ_WORKSPACE_TEXT = "<p>This panel asks you to select which projects you would like to create setups for.  All of the projects in the workspace will be shown here.</p><p><span class='helptitlesub1'>Projects</span><br>Select a Visual Studio project to include it in your setup project.</p><p><span class='helptitlesub1'>Configurations</span><br>You can also choose which configuration you would like to use. To specify a configuration, choose one from the drop-down list to the left of each project name.</p><p>Click Next to continue.</p>"

Public Const IHELP_VCWIZ_APPINFO_TITLE = " The Application Information Panel"
Public Const IHELP_VCWIZ_APPINFO_TEXT = "<p>The Application Information panel allows you to enter project information that will be used to populate fields in the <a href='IHelpProjectProperties.htm'>Project</a> and <a href='IHelpProductProperties.htm' class='link'>Product</a> information panels.</p><p>Although you can change these settings later in the IDE, it is best to provide as much information here as you can.</p><p>Click Next to continue.</p>"

Public Const IHELP_VCWIZ_SUMMARY_TITLE = " The Summary Panel"
Public Const IHELP_VCWIZ_SUMMARY_TEXT = "<p>The Summary panel allows you to view all of your settings before finally importing your project into InstallShield.  If you need to make any changes, click the Back button.</p><p>Click Finish to create your project.</p>"

Public Const IHELP_INTRO_WI_ASSIGNAPPS_TITLE = " Assigning Applications"

Public Const IHELP_INTRO_WI_ASSIGNAPPS_TEXT = "<p>When an application is assigned, it appears to be installed on the system.  All shortcuts are valid, an icon is displayed, and all file associations and registry entries have been created for the application.  When the user calls the application by double-clicking the displayed icon, the Windows Installer automatically installs the application, and then opens the program for the user.</p>"

Public Const IHELP_INTRO_WI_PUBLISHAPPS_TITLE=" Publishing Applications"

Public Const IHELP_INTRO_WI_PUBLISHAPPS_TEXT="<P>When an application is published, on the other hand, it does not appear to be installed on the system.  A published application can be opened via file extension, multipurpose Internet mail extension (MIME) type, or a user can instantiate it by using a list of published applications authored by the administrator in Windows Installer package. A published application will appear on the Add/Remove programs applet in the Control Panel, and can be activated from that location.</P>"

Public Const IHELP_INTRO_WI_PHASES_TITLE = " Phases of Windows Installer"

Public Const IHELP_INTRO_WI_PHASES_TEXT = "<P>Application installation is performed by the Installation Mechanism of Windows Installer, which consists of two phases: acquisition and execution.  During acquisition, a user prompts the installation of a particular application by double-clicking an assigned application or opening the file extension of a published program.  The installer then begins a sequence of actions to query the database and generate a script of the step-by-step procedure for installation.  During the execution phase, the database and installation information is passed to another process, where the installation script is generated.</P><P>A third phase of the installation mechanism, rollback, commences only in the event of a failed installation, restoring the computer to its original state.  The installer saves a copy of all files deleted during installation in a file called 'Config.msi'. This file is deleted upon successful installation.  If the installation is not successful, the deleted files are restored and the user receives a message indicating that the application installation was not completed.</P>"

Public Const IHELP_INTRO_WI_ADVERTISEFEAT_TITLE = " Advertising Your Features"

Public Const IHELP_INTRO_WI_ADVERTISEFEAT_TEXT = "<p>In the Components view of a project, developers may set the <a href='IHelpFeatAdvertise.htm'>Advertisement property</a> of any feature to Favor Advertise, Disallow Advertise, or None.  If you choose to advertise the feature, that feature will be advertised regardless of the setup mode in which the user runs your installation.  Note that specifying Favor Advertise in the Setup Design view enables advertisement; it does not automatically advertise your feature.  To advertise your product on an end-users system, you must select the option 'Will be installed when required' from the drop down list for your main executable of the Custom Setup dialog when running your setup.  Your application will display on the end users system as if it was already installed.</P>"



Public Const IHELP_ADDFILES_IDE_TITLE = " Create a Component from Scratch in the IDE"

Public Const IHELP_ADDFILES_IDE_TEXT = "<p>When you create a component by right-clicking in the Setup Design view or Components view, first select the component's Files item to view its file list.  Then do one of the following to associate files with this component:</p><ul><li>Drag and drop files from Windows Explorer onto the file list.</li><li>Right-click in the file list and select Add. In the resulting dialog, browse to select as many files as you want to add from that folder. Finally, click Open.</li></ul>"

Public Const IHELP_ADDFILES_IDE_MM_TITLE = " Create a Component from Scratch in the IDE"

Public Const IHELP_ADDFILES_IDE_MM_TEXT  = "<p>When you create a component by right-clicking in the Module Design view, first select the component's Files item to view its file list.  Then do one of the following to associate files with this component:</p><ul><li>Drag and drop files from Windows Explorer onto the file list.</li><li>Right-click in the file list and select Add. In the resulting dialog, browse to select as many files as you want to add from that folder. Finally, click Open.</li></ul>"

Public Const IHELP_ADDFILES_PROJWIZ_TITLE = " Create a Component in the Project Wizard"

Public Const IHELP_ADDFILES_PROJWIZ_TEXT = "<p>When you create a component in the Project wizard, you can add files in the wizard's Application Files panel with one of the following methods:</p><ul><li>Drag and drop files from Windows Explorer onto the file list.</li><li>Right-click in the file list and select Add or click the Add Files button. In the resulting dialog, browse to select as many files as you want to add from that folder. Finally, click Open.</li></ul>" 

Public Const IHELP_ADDFILES_COMPWIZ_TITLE = " Use the Component Wizard"

Public Const IHELP_ADDFILES_COMPWIZ_TEXT = "<p>Although the Component wizard may offer you a selection of files already installed on your system, most of the time you will arrive at a panel that asks you to add files.  Use one of the following methods:</p><ul><li>Drag and drop files from Windows Explorer onto the file list.</li>	<li>Right-click in the file list and select Add. In the resulting dialog, browse to select as many files as you want to add from that folder. Finally, click Open.</li></ul>"

Public Const IHELP_INTRO_ZAW_FEATURES_TITLE= " ZAW Features"
Public Const IHELP_INTRO_ZAW_FEATURES_TEXT = "<ul><li>User Profiles<p>ZAW enables administrators to create profiles for all users on the network.  These profiles include customized desktop settings, installed software, and locally cached files.  Both administrators and users will appreciate the convenience of roaming without requiring time-consuming reinstalls of specific applications and files.  Network files can be marked as shared read-only by the administrator.</p></li><li>Group Policy Templates<p>Administrators can also set up Group Policy Templates (GPTs) which allow the system configuration and software installation for certain groups of users.  For instance, a customer sales representative may only require access to a business-specific application, Microsoft Word, and an email application.  The administrator can set these privileges for this type of user.  A technical support engineer, on the other hand, may require access to several applications, including internet access for research, a database program to track customer calls and the support progress of each call, and perhaps a spreadsheet application to track expenses incurred from off-site repairs.  Both users would be prohibited from installing any software not specifically delineated in their respective GPT.</p></li><li>Client-Side Caching<p>ZAW supports client-side caching, in which users have the same view of the network, regardless of connection type.  Users may store certain files in their local cache memory, to speed up file downloads.  Users may also work offline.  While offline, users have access to all files they have while online.  Users may add, edit, or delete these files.  A copy of each file exists on both the server and the desktop computer, thus all changes to locally stored files will be automatically synchronized with those stored on the network server the next time the user logs on to the network.  Client-side caching allows the sharing of documents, while minimizing network traffic.</p></li><li>Side-by-Side Machine Replacement<p>In the event of a system crash, ZAW supports side-by-side machine replacement, enabling a user to switch machines, plug in the appropriate connectors, and continue with current editions of all files.</p></li></ul>"

Public Const IHELP_INTRO_ZAW_ASSIGNAPPS_TITLE = " What are Assigned Applications?"

Public Const IHELP_INTRO_ZAW_ASSIGNAPPS_TEXT = "<p>When a representative from a group first logs onto a system, all applications are assigned on his system.  The icons, shortcuts, file associations, and registry entries have been created.  The application appears to already be installed on the system.  When the user first opens one of these assigned applications, the <a href='IHelpIntroWi.htm'>Windows Installer</a> automatically installs the application, then opens the program for the user.</p>"

Public Const IHELP_INTRO_ZAW_PUBAPPS_TITLE = " What are Published Applications?"

Public Const IHELP_INTRO_ZAW_PUBAPPS_TEXT = "<p>Administrators may also create a list of published applications for all users.  Published applications do not appear on the user's system, but can be accessed via the administrator-created list, class IDs, GUIDs, or MIME types.  For users with limited job responsibilities, administrators can implement system lockdowns.  This allows specific functionalities of an application that the administrator judges to be beyond the skill level or job parameters of certain classes of users to be eliminated, thus reducing potential support associated with learning new applications.</p>"

Public Const IHELP_ERROR_NOTINIDE = "This page cannot be displayed correctly unless the product is running. Please close the help and re-open it from the IDE."

Public Const IHELP_ERROR_NOTINIDETEMP = "This page cannot be displayed correctly while this page is outside the IDE."

Public Const IHELP_ERROR_NOPROJECT = "You must have a project open in order to navigate to this view.  Would you like to have a project created for you?."

Public Const IHELP_WINDOWS = "Windows"
Public Const IHELP_HTMLCHAR_REG = "&reg;"

Public Const IHELP_BP_MULTIPLEPES_TITLE = " Components Cannot Contain Multiple EXEs, DLLs, OCXs, or HLPs"
Public Const IHELP_BP_MULTIPLEPES_TEXT  = "<p>Each component should contain only one &ldquo;portable executable&rdquo; file (an EXE, DLL, or OCX) or WinHelp file (HLP). Windows Installer components are designed such that all of the advanced settings and component properties, such as the code GUID, refer ideally to a single portable executable or help file.  Place other EXEs, DLLs, OCXs, or HLPs into new components.</p>"
Public Const IHELP_BP_FILEINMULTCOMPS_TITLE = " A File Cannot Be Associated with More than One Component"
Public Const IHELP_BP_FILEINMULTCOMPS_TEXT  = "<p>This Best Practice is extremely important for shipping reusable components and ensuring resiliency.  In fact, Microsoft recommends that no file be shipped in more than one component, &ldquo;even across products, product versions, and companies.&rdquo;</p>"
Public Const IHELP_BP_MMS_TITLE = " Use Merge Modules"
Public Const IHELP_BP_MMS_TEXT  = "<p>You should not distribute a file for which a merge module is available.  This Best Practice makes your job as a setup author easier in that merge modules contain all of the files, registry entries, and logic necessary to install a distinct piece of functionality. <br><br>Using merge modules also helps you comply with two related requirements&mdash;the Best Practice to avoid associating a file with more than one component and the Windows logo guideline not to ship any core components.<br><br>If you have the Best Practices monitoring option active, the Setup Best Practices wizard will alert you whenever you try adding to a component any file that is part of the merge modules that InstallShield provides.</p>"
Public Const IHELP_BP_SHORTCUT_TITLE = " Put a Shortcut's Target in Its Own Component"
Public Const IHELP_BP_SHORTCUT_TEXT  = "<p>Any file that will serve as the target for a shortcut belongs in its own component.  Make that file the <span class='glossary' title='A unique file for each component that the Windows Installer uses to detect the component&rsquo;s presence. In order to create advanced component settings or shortcuts, a key file must be specified.'>key file <img src='KeyIcon.gif'></span> for the component.</p>"
Public Const IHELP_BP_OTHERFILES_TITLE = " Group Other Files into Components"
Public Const IHELP_BP_OTHERFILES_TEXT  = "<p>Organize all files that do not fall into any of the above categories in components according to the files' requirements, such as a common destination folder or version checking.</p>"
Public Const IHELP_BP_DONTSELFREG_TITLE = " Don't Self-Register Files"
Public Const IHELP_BP_DONTSELFREG_TEXT  = "<p>Instead of calling self-registration functions to register and unregister COM server information, you should register this information for the component during setup (and the installer will unregister it during uninstallation). <br><br> Self-registration is an unreliable method for registering and unregistering files.  One advantage of having the setup register the information is that if the file is advertised, or not immediately installed, the registration is in place when the file is later requested from the installer.  Therefore, InstallShield supports advanced settings specifically for registering COM servers.</p>"


Public Const SETUPGLOBAL_OVERVIEW_TITLE = " Working in the Setup Design Views"
Public Const SETUPGLOBAL_OVERVIEW_TEXT = "<p>The Setup Design area has been broken down into four distinct sections in order to make designing your setup a fluid process.  The table below shows some common actions that you may need to perform in the Setup Design area and the views where these actions can be performed.</p><p><table border=1 style='border-style: ridge; border-width:1'><tr><td style='font-weight:bold' style='color:white' bgcolor=gray>Action</td><td class='dots' title='Setup Design' bgcolor=gray><img src='nbGlobal.gif' width=16 height=16 border=0></td><td class='dots' title='Features' bgcolor=gray><img src='nbFeatures.gif' width=16 height=16 border=0'></td><td class='dots' title='Components' bgcolor=gray><img src='nbComponents.gif' width=16 height=16 border=0></td><td class='dots' title='Merge Modules' bgcolor=gray><img src='nbMergeModules.gif' width=16 height=16 border=0></td></tr><tr><td><span class='link' id='IHelpAddRemoveRenameFeature'>Add, modify, or delete a feature</span></td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td></tr><tr><td><span class='link' id='IHelpAddRemoveRenameComponent'>Add or modify components</span></td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td></tr><tr><td><span class='link' id='IHelpAddRemoveRenameComponent'>Delete components</span></td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td></tr><tr><td><span class='link' id='IHelpAddRemoveRenameComponent'>Remove (disassociate) components</span></td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td></tr><tr><td><span class='link' id='IHelpMMWiz'>Add or modify merge modules</span></td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td></tr><tr><td><span class='link' id='IHelpMergeModules'>Delete merge modules</span></td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><tr><td><span class='link' id='IHelpMergeModules'>Remove (disassociate) merge modules</span></td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td></tr><tr><td><span class='link' id='IHelpFeatAssociateComponents'>Associate components with features</span></td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td></tr><tr><td><span class='link' id='IHelpMMWiz'>Associate merge modules with features</span></td><td class='dots'><img src='CHECK.gif' width=16 height=16 border=0 alt=''></td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td><td class='dots'>&nbsp;</td></tr></table></p><table><tr><td valign='top'><p>The icons at the top of each column represent the icons on the header bar of the Setup Design view.  Clicking these icons on the header bar will take you to the corresponding view.</td><td><img src='CallOutsGlobal.gif'></td></tr></table></p>"

Public Const SETUPGLOBAL_FEATURE_TITLE = " Features"
Public Const SETUPGLOBAL_FEATURE_TEXT = "<p>Features are the building blocks of your application from your end user's perspective. That is, they represent a specific capability of your product, such as its help files or a part of a product suite, that can be installed or not installed based on the end user's selections. Your entire application should be divided into features that perform a specific purpose. To add a feature to your project, right-click on the Setup Design item and select New Feature.</p>"

Public Const SETUPGLOBAL_SUBFEATURE_TITLE = " Subfeatures"
Public Const SETUPGLOBAL_SUBFEATURE_TEXT = "<p>Subfeatures are further elements or divisions of a feature. To add a new subfeature, right-click on the parent feature and select New Feature.</p>"

Public Const SETUPGLOBAL_FEATUREREORDER_TITLE = " Reordering Features"
Public Const SETUPGLOBAL_FEATUREREORDER_TEXT = "<p>When your end users install your product, the <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpCustomSetupDlg.htm"")'>Custom Setup dialog</a> displays the features in the same order that they are displayed in the IDE.  If you would like to change the order in which the features are displayed, you can reorder them.</p><p>To change the order of your features, right-click the feature that you would like to move and select Move Up or Move Down, depending on the direction that you would like the feature to move.  You may also move a feature left or right, thereby making it a subfeature of another feature or a stand-alone feature.  Additionally, you can drag-and-drop features and subfeatures from one location to another.</p>"

Public Const SETUPGLOBAL_COMPONENT_TITLE = " Components"
Public Const SETUPGLOBAL_COMPONENT_TEXT = "<p>Components allow you to organize your application data into similar groups. Unlike features they constitute the developer's view of a project&mdash;items such as files, registry entries, and shortcuts. Components are associated with features, and a component may belong to more than one feature.</p><p>There are three ways to create a component in this view:</p><ul><li>Right-click on the topmost item and select New Component.</li><!--<img id='btnShowMe' src='showmebutton.gif' title='Click here to launch a demo and see the Best Practices option in action.' style='cursor:hand' align='right' class='Demo'>--><li>Right-click on the topmost item and select Component Wizard to launch the wizard and let InstallShield organize your files into components according to Setup Best Practices.</li><li>Launch the Component wizard, select a predefined component type, and define the component yourself.</li></ul><p>The Setup Design view is the only place where you can define feature-component relationships.  While you can create and modify components in either the Components view or the Setup Design view, it is here that you associate a component with one or more feature. To specify which of the available components you want to associate with a feature, right-click on the feature or subfeature and select Insert Components. To remove the feature-component relationship, right-click on a component and select Remove from feature.  (Removing a component does not delete the component from your project.  You must delete it from either the Components view or the Setup Design view to delete it permanently.)</p>"

Public Const SETUPGLOBAL_COMPONENTDATA_TITLE = " Component Data"
Public Const SETUPGLOBAL_COMPONENTDATA_TEXT = "<p>Files, registry data, and shortcuts are elements that are added to a component to complete the hierarchy, as shown above. To create these items for a component, click on the component and enter your information into the property sheet or editor to the right.  More help is available for each item throughout the IDE.</p><p>One of your component's files can serve as its key file.  A key file is a file that the Windows Installer uses to detect the component's  presence. And in order to create advanced component settings or shortcuts, a key file must be specified. To specify one of your component's files as the key file, right click in the component's file list, and select Set Key File. The file icon <img src='fileicon.gif'> for that file is replaced with a key icon <img src='keyicon.gif'>.</p>"

Public Const SETUPGLOBAL_ADVANCEDSETTINGS_TITLE = " Advanced Settings"
Public Const SETUPGLOBAL_ADVANCEDSETTINGS_TEXT = "<p>By specifying the advanced settings, you can <span class='glossary' title ='Publishing is a type of advertising (just-in-time installation) in which no user-interface elements are created for the component during installation, but the component can be installed through the Add/Remove Programs applet of the Control Panel or when an installed component requests the published component from the installer.'>publish</span> your component, register COM servers, file extensions, MIME types, and so on.  You can also use the component's advanced settings to create an application paths entry in the registry.</p>"

Public Const SETUPGLOBAL_MERGEMODULES_TITLE = " Merge Modules"
Public Const SETUPGLOBAL_MERGEMODULES_TEXT = "<p><a href='#' onclick='JavaScript:OpenHelpToTopic (""IHelpMergeModules.htm"")'>Merge modules</a> are subsets of a setup that you can use to redistribute frequently used files or complex third-party software. InstallShield objects are similar to merge modules, except that you can customize the object and any related elements. (Objects are distinguished visually from merge modules by their icon: <img src='smObject.gif' align='texttop'>.)</p><p>To add a merge module or object to your project, navigate to the Setup Design view and right-click on the feature that you would like your new merge module to be associated with, and select <a href='#' onclick='JavaScript:OpenHelpToTopic (""IHelpMMWiz.htm"")'>Merge Module Wizard</a> from the list.  To remove (disassociate) a merge module or object from a certain feature, navigate to the Setup Design view and right-click on the merge module that you would like to remove. Select Remove from the list.  You can permanently delete merge modules from your setup in either the Setup Design view or the Merge Modules view.  To do this, right-click on a merge module and select Delete.</p><p>To customize an object, right-click and select Configure in the Setup Design or Merge Modules view. </p>"

Public Const IRELEASE_SETUPEXE_TITLE = " Install Windows Installer (Setup.exe)"
Public Const IRELEASE_SETUPEXE_TEXT = "<p>By default, InstallShield creates an executable file that checks to see if the target system has the required version of Windows Installer.  If Windows Installer is not found or if the version found is earlier than the version you are distributing, Setup.exe installs the necessary version, and then runs your setup package.</p><p>To turn this feature off, select Options from the Tools menu. Then, deselect the check box labeled Setup.exe. You can also turn this feature off in the Release wizard and have it only apply to the current release.</p><p>For more information on Setup.exe, see <a href='#' onclick='JavaScript:OpenHelpToTopic (""IHelpSetup_EXE.htm"")'>Installing Windows Installer with InstallShield</a>."

Public Const IRELEASE_RELEASEWIZ_TITLE = " Launch the Release Wizard"
Public Const IRELEASE_RELEASEWIZ_TEXT = "<p>To launch the Release wizard and build your setup package, do one of the following:</p><ul><li>Click the Release Wizard button <img src='releasewizard.gif' alt='Release Wizard'> on the toolbar.</li>	<li>Right-click on the top node of the Release explorer and select Release Wizard. </li><li>Right-click on a release name in the tree control in the Releases view, and select Release Wizard. </li></ul><p>Carefully follow the instructions in the Release wizard's panels. </p>"


Public Const IRELEASE_CMDLINE_TITLE = " Build a Release from the Command Line"
Public Const IRELEASE_CMDLINE_TEXT = "<p>Building a release from the command line can be useful if you build your product with a batch file. InstallShield gives you the option to build a release, build it in silent mode, output any messages to a log file, and compress the setup, all from the command line.  For more information on building your release from the command line, see <a href='#' onclick='JavaScript:OpenHelpToTopic (""IHelpCmdLineBld.htm"")'>Building a Setup from the Command Line</a>.</p>"

Public Const IRELEASE_REBUILD_TITLE = " Rebuild a Release"
Public Const IRELEASE_REBUILD_TEXT = "<p>You can rebuild a release at any time using the default entries you already provided in the Release wizard.  The release that currently has focus is rebuilt.  To rebuild a release, do one of the following: </p><ul><li>Click the Build Release button <img src='BuildButton.gif' alt='Build Release'> on the toolbar.</li>	<li>Select Build Release from the Release menu. </li>	<li>Right-click on a release name in the tree control in the Releases view, and select Build. </li></ul><p>You can also run the Release wizard again to rebuild a release. Since the wizard stores the release settings in your InstallShield project file, the wizard displays all of the options that you set when you last built the release, even if you deleted the actual release. </p>"

Public Const IRELEASE_RUN_TITLE = " Run the Built Setup"
Public Const IRELEASE_RUN_TEXT = "<p>To run any of your built setup packages from the IDE, do one of the following: <ul><li>Click the Run Setup button <img src='RunSetupButton.gif' alt='Run Setup'> on the toolbar.</li><li>Right-click on a release name in the Releases view, and select Run Setup. </li><li>Select Run Setup from the Release menu. </li></ul></p><p>InstallShield runs the release that currently has focus in the Releases view.</p>"

Public Const IPRODUCTS_PROPERTIES_TITLE = " Set Product Properties"
Public Const IPRODUCTS_PROPERTIES_TEXT = "<p>You must set the product properties before you proceed. To set product properties, select your product in the tree control.  Its property sheet opens to the right. Then, click on a property to edit it.</p><p>More help is available in the IDE for each property.</p>"

Public Const WIZPANEL_DOCCONV_SAMPLE1 = "Welcome"
Public Const WIZPANEL_DOCCONV_SAMPLE2 = "Choose a Type"
Public Const WIZPANEL_DOCCONV_SAMPLE3 = "Non-Default Selection"
Public Const WIZPANEL_DOCCONV_SAMPLE4 = "Summary"

Public Const DOCCONVENTION_CLICKME_TITLE = " Click Me!"
Public Const DOCCONVENTION_CLICKME_TEXT  = "<p>Many of the help topics contain text in a drop-down format identical to this one.  To return this text to its hidden state, click the title again.</p>"

Public Const SD_FEATURE_FEATURES_TITLE = " Features"
Public Const SD_FEATURE_FEATURES_TEXT  = "<p>Features are the building blocks of your application from your user's perspective. That is, they represent a specific capability of your product, such as its help files or a part of a product suite that can be installed or not installed based on the end user's selections. Your entire application should be divided into features that perform a specific purpose.</p> <p><span class='clsIswiSetup'>To add a feature to your project, right-click on the Features item and select New Feature.</span><span class='clsIsX'>To add a feature to your setup, right-click on the Features item and select New Feature. </span></p>"
Public Const SD_FEATURE_SUBFEATURES_TITLE = " Subfeatures"
Public Const SD_FEATURE_SUBFEATURES_TEXT  = "<p>Subfeatures are further divisions of a feature. Since features should be self-contained elements of an application or application suite that a user can selectively install, it might make the most sense for you to organize portions of your application as subfeatures of a &ldquo;parent&rdquo; feature. Assuming that the features are all visible, your end user can then select which portions of a feature to install in the Custom Setup dialog.</p> <p>To add a new subfeature, right-click on the parent feature and select New.</p>"
Public Const SD_COMP_ADDCOMPS_TITLE = " Add Components"
Public Const SD_COMP_ADDCOMPS_TEXT  = "<p>Components allow you to organize your application data into similar groups. Unlike features they constitute the developer's view of a project&mdash;items such as files, registry entries, and shortcuts. Components are associated with features, and a component may belong to more than one feature.</p><p>There are three ways to create a component in this view:</p><ul><li>Right-click on the topmost item and select New Component.</li><!--<img id='btnShowMe' src='showmebutton.gif' title='Click here to launch a demo and see the Best Practices option in action.' style='cursor:hand' align='right' class='Demo'>--><li>Right-click on the topmost item and select Component Wizard to launch the wizard and let InstallShield organize your files into components according to Setup Best Practices.</li><li>Launch the Component wizard, select a predefined component type, and define the component yourself.</li></ul>"
Public Const SD_COMP_GLOBALVSCOMP_TITLE = " The Components View vs. the Setup Design View"
Public Const SD_COMP_GLOBALVSCOMP_TEXT = "<p>Although the Components view appears to be an exact subset of the Setup Design view and, in fact, you can create and modify components in precisely the same way in both views, there is one major difference between them.   The Setup Design view is different because it allows you to associate components with features.  Component/Feature relationships can also be defined in the <a href='#' onclick='JavaScript:OpenHelpToTopic (""IHelpISXFiles.htm"")'>Files view</a>.</p>"

Public Const PROJ_PRODUCTS_TITLE = " Set Product Properties"
Public Const PROJ_PRODUCTS_TEXT  = "<p>You must set the product properties before you proceed. To set product properties, select your product in the tree control.  Its property sheet opens to the right. Then, click on a property to edit it.</p> <p>More help is available in the IDE for each property. </p>"

Public Const SEQ_ADMIN_INSERTCA_TITLE = " Insert a Custom Action"
Public Const SEQ_ADMIN_INSERTCA_TEXT  = "<p>Double-click Custom Action Wizard to launch the wizard and insert a custom action into your setup. For more information on using the Custom Action wizard, click on the Custom Action Wizard item in the tree view. </p>"
Public Const SEQ_ADMIN_ACTIONPROPERTIES_TITLE = " Action Properties"
Public Const SEQ_ADMIN_ACTIONPROPERTIES_TEXT  = "<p>The Internal Name and Description properties of each built-in action and dialog properties are read-only. However, you can edit the Condition property by selecting it in the property sheet. For more information about conditions, see <span id='moConditions' style='cursor:hand;color:sienna;text-decoration:underline' class='clsmoConditions'>Building Conditional Statements</span>.</p><p>In the Administration sequence view the custom actions display the properties that you set in the Custom Action wizard. Unlike built-in actions and dialogs, you cannot edit a custom action's property sheet directly. You must launch the Custom Action wizard again to edit custom action properties. </p>"
Public Const SEQ_ADVERT_ACTIONPROPERTIES_TEXT = "<p>The Internal Name and Description properties of each built-in action and dialog properties are read-only. However, you can edit the Condition property by selecting it in the property sheet. For more information about conditions, see <span id='moConditions' style='cursor:hand;color:sienna;text-decoration:underline' class='clsmoConditions'>Building Conditional Statements</span>.</p><p>In the Advertisement sequence view the custom actions display the properties that you set in the Custom Action wizard. Unlike built-in actions and dialogs, you cannot edit a custom action's property sheet directly. You must launch the Custom Action wizard again to edit custom action properties. </p>"
Public Const SEQ_INSTALL_ACTIONPROPERTIES_TEXT = "<p>The Internal Name and Description properties of each built-in action and dialog properties are read-only. However, you can edit the Condition property by selecting it in the property sheet. For more information about conditions, see <span id='moConditions' style='cursor:hand;color:sienna;text-decoration:underline' class='clsmoConditions'>Building Conditional Statements</span>.</p><p>In the Installation sequence view the custom actions display the properties that you set in the Custom Action wizard. Unlike built-in actions and dialogs, you cannot edit a custom action's property sheet directly. You must launch the Custom Action wizard again to edit custom action properties. </p>"

Public Const PE_ADDRECORD_TITLE = " Add a Record to a Table"
Public Const PE_ADDRECORD_TEXT  = "<p>Any of the following actions will add a new record, or row, to a table:</p><ul><li>Right-click in a table and select Create Row. </li><li>Double-click in the last row of the table.</li><li>Press the Enter key in the last row of the table.</li></ul>"
Public Const PE_DELETERECORD_TITLE = " Delete a Record"
Public Const PE_DELETERECORD_TEXT  = "<p>Either of the following actions will remove a row from a table:</p><ul><li>Press the Delete key.</li><li>Right-click in a row and select Delete Row. </li></ul>"
Public Const PE_EDITRECORD_TITLE = " Edit a Field"
Public Const PE_EDITRECORD_TEXT  = "<p>Use any of the following actions to edit a field in a table:</p><ul><li>Double-click in the field.</li><li>Right-click in the field and select Edit.</li> <li>Press the Enter key in the field.</li><li>Press the F2 key in the field.</li>  </ul>  <p>Then, enter a new value or modify the existing one in the resulting dialog. You can surmise the required data type for the field from the column headings.  For example, &ldquo;S255&rdquo; indicates a string value with a maximum length of 255 characters. </p>   <p>If the field takes a foreign key into another table, the Power Editor gives you a list of existing fields from that table.  <p><table><tr valign=top>	<td><img src='warning.gif'></td>	<td>The Power Editor does not perform any validation on the entries you make in the tables.  For example, it does not check to see if a field is &ldquo;non-nullable;&rdquo; you must be already familiar enough with the MSI tables to know which fields are required.  Refer to <a href='#' onclick='JavaScript:LaunchMSIHelp ("""")'>Msi.chm</a> for complete descriptions of the tables.</td></tr></table></p>"
Public Const PE_BINARYDATA_TITLE = " Entering Binary Data"
Public Const PE_BINARYDATA_TEXT  = "<p>You can make references to binary data in the Binary and Patch tables. Make sure to include the fully qualified path and filename.  Otherwise, InstallShield will not include the file in the MSI package.</p>"

Public Const ST_EDITING_TITLE = " Editing String Table Entries"
Public Const ST_EDITING_TEXT  = "<p>Double-click on a string ID, value, or comment in the String Table editor to modify the entry.  If you rename a string ID, it is renamed in every string table. </p><p>You can add a new entry in one of two ways:</p><ul><li>Right-click anywhere in the editor and select New.  A string ID will be added to each string table with an empty value and comment.  </li><li>Right-click in the string table and select Create &amp; Set.  Next, modify the ID, value, and comment in the resulting dialog.  The new entry, including the value and comment, will be added to the string table for <i>each</i> language. </li></ul><p>Right-click on an entry and select Delete to remove it from all of the string tables.  </p><p>You can also add, remove, and modify string table entries while working in property sheets. Properties that accept localizable text require you to use a string ID and present you with a string table for the <a href='#' onclick='JavaScript:OpenHelpToTopic (""IHelpGlobDefLang.htm"")'>default language</a>.</p><p>Windows Installer permits special formatting for many of its data types, such as using brackets to reference the value of an installer property.  See <a href='' onclick='JavaScript:LaunchMSIHelp ("""")'>Windows Installer help</a> for more information on data types. </p>"
Public Const ST_TRANSLATING_TITLE = " Translating String Tables"
Public Const ST_TRANSLATING_TEXT  = "<p>In addition to editing values in-line, you can copy string tables to text files to send to translators.  </p><p>To export an entire string table, right-click on the string table in the Project explorer under the String Tables folder and select Export.  Then, browse to the .txt file you want to copy the string table to and click Open.  The string table is exported to a tab-delimited text file, overwriting any previous contents of that file. Now you can send the entire file off for translation. </p><p>Similarly, you can select any number of entries in the String Table editor, right-click, and select Export to send the selected portion of the string table to a text file. </p><p>To import a tab-delimited text file into a string table, right-click on the string table in the Project explorer under the String Tables folder and select Import. Next, browse to the .txt file you want to merge into the string table and click Open.  The String Table editor will check for conflicts with string IDs and ask you if you want to overwrite the existing entry.</p>"
Public Const ST_MULTLANGS_TITLE = " Working with Multiple Languages"
Public Const ST_MULTLANGS_TEXT  = "<p>The String Tables folder contains a string table for each language supported in your project. Each string table must have identical string IDs: adding an entry to any string table causes the same ID to be added to each string table; deleting an entry deletes it from all string tables; and any string tables added to the project will contain the same string IDs as the others.  </p>"
Public Const ST_IDEPROPS_TITLE = " Using String IDs in the IDE"
Public Const ST_IDEPROPS_TEXT  = "<p>The InstallShield IDE requires that you use a string ID for any property that accepts a localizable value, such as a feature's Description property.  While editing such a property, you can select an existing string identifier by right-clicking on the string table and, if desired, edit its value for the default language, or you can add a new string identifier to the string tables.</p> <p>In fact, simply by typing a description into the property sheet, you are actually adding a new entry to the string tables and setting the value for the default language.  Your new string ID is named NEW_STRING<i>N</i>, where <i>N</i> is a successive number. </p><p>You can also add and delete string table entries while working in a property sheet by right-clicking in the string table there the same way you would in this view. </p>"

Public Const WIZPANEL_PW_WELCOME    = "Welcome"                  ' IWizProjectWelcome.htm
Public Const WIZPANEL_PW_WIZPROJECT = "Wizard Project"           ' IWizProjectProject.htm
Public Const WIZPANEL_PW_APPINFO    = "Application Information"  ' IWizProjectAppInfo.htm
Public Const WIZPANEL_PW_LANGUAGES  = "Setup Languages"          ' IWizProjectLanguages.htm
Public Const WIZPANEL_PW_APPFEAT    = "Application Features"     ' IWizProjectAppFeatures.htm
Public Const WIZPANEL_PW_APPCOMP    = "Application Components"   ' IWizProjectAppComponents.htm
Public Const WIZPANEL_PW_SD         = "Setup Design"             ' IWizProjectSetupDesign.htm
Public Const WIZPANEL_PW_APPFILES   = "Application Files"        ' IWizProjectAppFiles.htm
Public Const WIZPANEL_PW_SHORTCUTS  = "Create Shortcuts"         ' IWizProjectShortcuts.htm
Public Const WIZPANEL_PW_REG        = "Registry Data"            ' IWizProjectRegistryData.htm
Public Const WIZPANEL_PW_DIALOGS    = "Dialogs"                  ' IWizProjectDialogs.htm
Public Const WIZPANEL_PW_SUMMARY    = "Wizard Summary"           ' IWizProjectSummary.htm

Public Const WIZPANEL_RW_START      = "Welcome"                     'IWPReleaseStart.htm
Public Const WIZPANEL_RW_LABEL      = "Product Configuration"                 'IWPReleaseLabel.htm
Public Const WIZPANEL_RW_SPECIFY      = "Specify a Release"         ' IWPReleaseSpecify.htm
Public Const WIZPANEL_RW_FILTER       = "Filtering Settings"         ' IWPReleaseFiltering.htm
Public Const WIZPANEL_RW_FORMAT       = "Media Type &amp; Patch Optimization"                'IWPReleaseFormat.htm
Public Const WIZPANEL_RW_SPANNING     = "Disk Spanning Options"     'IWPReleaseDiskSpanning.htm
Public Const WIZPANEL_RW_ADVSPANNING  = "Disk Spanning Advanced Settings"   'WPReleaseAdvDiskSpanning.htm
Public Const WIZPANEL_RW_CONFIG       = "Release Configuration"     ' IWPReleaseType.htm
Public Const WIZPANEL_RW_CUSTOMCONFIG   ="Custom Compression Settings" 'IWPReleaseTypeCustom.htm
Public Const WIZPANEL_RW_LANGS 	      = "Setup Languages"  	        ' IWPReleaseLangs.htm
Public Const WIZPANEL_RW_MODULE       = "Merge Module Options"      ' IWPReleaseModule.htm
Public Const WIZPANEL_RW_SETUPEXE     = "Advanced Settings"          ' IWPReleaseLaunch.htm
Public Const WIZPANEL_RW_PFTW         = "Digital Signature &amp; Securtiy"  ' IWPReleaseSetupExe.htm
Public Const WIZPANEL_RW_SUMMARY      = "Release Settings Summary"  ' IWPReleaseSummary.htm
Public Const WIZPANEL_RW_BUILDSTATUS  = "Release Build Status"      ' IWPBuild.htm



Public Const WIZPANEL_CW_WELCOME        = "Welcome"          ' IWPComponentWelcome.htm
Public Const WIZPANEL_CW_TYPE           = "Component Type"   ' IWPComponentTypes.htm

Public Const WIZPANEL_CW_BP_DESTINATION = "Best Practices&#150;Destination" ' IWPComponentBPracStart.htm
Public Const WIZPANEL_CW_BP_FILES       = "Best Practices&#150;Files"       ' IWPComponentBPracFiles.htm
Public Const WIZPANEL_CW_BP_SUMMARY     = "Summary"                         ' IWPComponentBPracSummary.htm, but the IDE page doesn't exist anymore.

Public Const WIZPANEL_CW_COM_EXE      = "COM Server Executable"      ' IWPComponentCOMStart.htm
Public Const WIZPANEL_CW_COM_CLASSES  = "Classes"                    ' IWPComponentCOMInfo.htm
Public Const WIZPANEL_CW_COM_CONTEXT  = "Context Types"              ' IWPComponentCOMContext.htm
Public Const WIZPANEL_CW_COM_TYPELIB  = "Type Library"               ' IWPComponentCOMTypeLib.htm
Public Const WIZPANEL_CW_COM_APPIDGEN = "AppID General Information"  ' IWPComponentCOMAppID.htm
Public Const WIZPANEL_CW_COM_APPIDADV = "AppID Advanced Information" ' IWPComponentCOMAppIDInfo.htm
Public Const WIZPANEL_CW_COM_SUMMARY  = "Summary"                    ' IWPComponentCOMSummary.htm

Public Const WIZPANEL_CW_CTRLNTSERV_SPECIFY = "Specify Service"       ' IWPComponentCtrlSvcSpecify.htm
Public Const WIZPANEL_CW_CTRLNTSERV_INST    = "Installation Events"   ' IWPComponentCtrlSvcInst.htm
Public Const WIZPANEL_CW_CTRLNTSERV_UNINST  = "Uninstallation Events" ' IWPComponentCtrlSvcUninst.htm
Public Const WIZPANEL_CW_CTRLNTSERV_WAIT    = "Wait Type"             ' IWPComponentCtrlSvcWait.htm
Public Const WIZPANEL_CW_CTRLNTSERV_SUMMARY = "Summary"               ' IWPComponentCtrlSvcSummary.htm

Public Const WIZPANEL_CW_ODBC_DRIVERS     = "Specify ODBC Drivers"      ' IWPComponentODBCDriver.htm
Public Const WIZPANEL_CW_ODBC_DSNS        = "Specify ODBC Data Sources" ' IWPComponentODBCDataSource.htm
Public Const WIZPANEL_CW_ODBC_TRANSLATORS = "Specify ODBC Translators"  ' IWPComponentODBCTranslator.htm
Public Const WIZPANEL_CW_ODBC_SUMMARY     = "Summary"                   ' IWPComponentODBCSummary.htm

Public Const WIZPANEL_CW_NTSERV_EXE     = "NT Service Executable"  ' IWPComponentNTSvcStart.htm
Public Const WIZPANEL_CW_NTSERV_INFO    = "Service Information"    ' IWPComponentNTSvcInfo.htm
Public Const WIZPANEL_CW_NTSERV_LOAD    = "Service Load Order"     ' IWPComponentNTSvcLoad.htm
Public Const WIZPANEL_CW_NTSERV_ERROR   = "Error Control"          ' IWPComponentNTSvcError.htm
Public Const WIZPANEL_CW_NTSERV_LOGON   = "Service Logon"          ' IWPComponentNTSvcLogon.htm
Public Const WIZPANEL_CW_NTSERV_SUMMARY = "Summary"                ' IWPComponentNTSvcSummary.htm

Public Const WIZPANEL_CW_FONTS_INSTALLED = "Add Installed Fonts" ' IWPComponentFontSpecify.htm
Public Const WIZPANEL_CW_FONTS_NEW       = "Add New Fonts"       ' IWPComponentFontSpecify2.htm
Public Const WIZPANEL_CW_FONTS_SUMMARY   = "Summary"             ' IWPComponentFontSummary.htm

Public Const WIZPANEL_MM_START		 = "Welcome"					'IWPMergeModuleStart.htm
Public Const WIZPANEL_MM_CHOOSE	     = "Merge Module Gallery"			'IWPMergeModuleGallery.htm
Public Const WIZPANEL_MM_DESTINATION    =  "Merge Module Destination"
Public Const WIZPANEL_MM_FEATURE     = "Associate Merge Modules with Features"	'IWPMergeModuleFeature.htm
Public Const WIZPANEL_MM_FEATURETREE = "Associate Merge Modules with Multiple Features" 'IWPMergeModuleFeatureTree.htm
Public Const WIZPANEL_MM_SUMMARY	 = "Summary"					'IWPMergeModuleSummary.htm

Public Const WIZPANEL_CUSTOMACTION_WELCOME	= "Welcome"				'IWizCustomActionWelcome.htm
Public Const WIZPANEL_CUSTOMACTION_NAME		= "Basic Information"   'IWizCustomActionName.htm
Public Const WIZPANEL_CUSTOMACTION_TYPE		= "Action Type"         'IWizCustomActionType.htm
Public Const WIZPANEL_CUSTOMACTION_FNDEF    = "Function Definition" 'IWizCustomActionStdDLL.htm
Public Const WIZPANEL_CUSTOMACTION_SOURCE	= "Action Parameters"			'IWizCustomActionSource.htm
Public Const WIZPANEL_CUSTOMACTION_EXECUTION 	= "Additional Options"			'IWizCustomActionTypeEx.htm
Public Const WIZPANEL_CUSTOMACTION_SUMMARY	= "Summary"				'IWizCustomActionSummary.htm
Public Const WIZPANEL_CUSTOMACTION_SCRIPTS	= "In-Sequence Scripts"			'IWizCustomActionScript.htm

Public Const WIZPANEL_REGIMPORT_WELCOME		= "Welcome"			'IWizRegistryFileImporterFileInfo.htm
Public Const WIZPANEL_REGIMPORT_CONFLICT	= "Import Conflict Options"	'IWizRegistryFileImporterConflictInfo.htm
Public Const WIZPANEL_REGIMPORT_PROGRESS	= "Progress"			'IWizRegistryFileExporterProgress.htm

Public Const WIZPANEL_REGEXPORT_WELCOME		= "Welcome"			'IWizRegistryFileExporterFileInfo.htm
Public Const WIZPANEL_REGEXPORT_BRANCH		= "Export Range"		'IWizRegistryFileExporterBranchInfo.htm
Public Const WIZPANEL_REGEXPORT_PROGRESS	= "Progress"			'IWizRegistryFileExporterProgress.htm


Public Const WIZPANEL_VBWIZ_WELCOME	= "Welcome"				'IWPVBWelcome.htm
Public Const WIZPANEL_VBWIZ_VBP		= "Visual Basic Project File" 		'IWPVBSelectVBP.htm
Public Const WIZPANEL_VBWIZ_VBEXE	= "Location of Visual Basic"		'IWPVBFindVB.htm
Public Const WIZPANEL_VBWIZ_PROGRESS	= "Wizard Progress"			'IWPVBProgress.htm
Public Const WIZPANEL_VBWIZ_SUMMARY	= "Scan Results"			'IWPReleaseSummary.htm
Public Const WIZPANEL_VBWIZ_COMPLETE	= "Completing the Visual Basic Wizard"	'IWPVBComplete.htm
Public Const WIZPANEL_VBWIZ_PROGRESS2   = "Import Progress"			'IWPVBProgress.htm

Public Const WIZPANEL_CONVERTMSI_WELCOME    = "Welcome"             'IWPOpenMSIWelcome.htm
Public Const WIZPANEL_CONVERTMSI_LOCATION   = "File Locations"      'IWPOpenMSILocation.htm
Public Const WIZPANEL_CONVERTMSI_OPENING    = "Opening Setup Package or Merge Module" 'IWPOpenMSIOpening.htm
Public Const WIZPANEL_CONVERTMSI_FINISH     = "Completing the Open MSI/MSM Wizard"  'IWPOpenMSIFinish.htm

Public Const WIZPANEL_CONVERTPATH_WELCOME = "Welcome"               'IWizConvertPathWelcome.htm
Public Const WIZPANEL_CONVERTPATH_SEARCH =  "Search"                'IWizConvertPathSProgress.htm
Public Const WIZPANEL_CONVERTPATH_RECOMMEND = "Search Results and Recommendations"        'IWizConvertPathRec.htm
Public Const WIZPANEL_CONVERTPATH_CONVERTING ="Updating Your Project" 'IWizConvertPathAProgress.htm
Public Const WIZPANEL_CONVERTPATH_FINISH  = "Update Completed"      'IWizConvertPathFinish.htm

Const WIZPANEL_PATCH_WELCOME  = "Welcome"                 ' PatchWizWelcome.htm
Const WIZPANEL_PATCH_PCPFILE  = "Patch Creation Project"  ' PatchWizPcp.htm
Const WIZPANEL_PATCH_PREV     = "Previous Packages"       ' PatchWizPrevious.htm
Const WIZPANEL_PATCH_NEW      = "Newer Package"           ' PatchWizNewMsi.htm
Const WIZPANEL_PATCH_ID       = "Patch Package Identity"  ' PatchWizMspId.htm
Const WIZPANEL_PATCH_REMOVE   = "Previous Patches"      ' PatchWizRemoveMSP.htm
Const WIZPANEL_PATCH_SETTINGS = "Patch Creation Settings" ' PatchWizSettings.htm
Const WIZPANEL_PATCH_SUMMARY  = "Summary"                 ' PatchWizComplete.htm

Public Const WIZPANEL_TRANSFORM_WELCOME = "Welcome"     'IWizTransformWelcome.htm
Public Const WIZPANEL_TRANSFORM_IDENTIFY = "Specify Files"  'IWizTransformIdentify.htm
Public Const WIZPANEL_TRANSFORM_VALIDATE = "Validation Settings"  'IWizTransformValidate.htm
Public Const WIZPANEL_TRANSFORM_SUPPRESS = "Suppress Error Conditions"  'IWizTransformSuppress.htm
Public Const WIZPANEL_TRANSFORM_LOCATION = "Specify Output Files"   'IWizTransformLocation.htm
Public Const WIZPANEL_TRANSFORM_SUMMARY= "Summary"  'IWizTransformSummary.htm
Public Const WIZPANEL_TRANSFORM_COMPLETE = "Completing the Transform Wizard"    'IWizTransformComplete.htm

Public Const WIZPANEL_VALIDATE_WELCOME  = "Welcome"      ' IWizValWelcome.htm
Public Const WIZPANEL_VALIDATE_PROGRESS = "Progress"     ' IWizValProgress.htm
Public Const WIZPANEL_VALIDATE_RESULTS  = "Results"      ' IWizValSummary.htm

Public Const WIZPANEL_NEWLANG_WELCOME = "Welcome"        'IWPNewLangWelcome.htm
Public Const WIZPANEL_NEWLANG_LANGUAGES = "Project Language"    'IWPNewLangLanguages
Public Const WIZPANEL_NEWLANG_PROJECTS = "Project Files"    'IWPNewLangProjects.htm
Public Const WIZPANEL_NEWLANG_SUMMARY = "Summary"       'IWPNewLangSummary.htm

Const WIZPANEL_ACCESS_WELCOME   = "Welcome"                 ' IWizAccess97Welcome.htm
Const WIZPANEL_ACCESS_DBFILE    = "Access 97 Database File" ' IWizAccess97DatabaseFile.htm
Const WIZPANEL_ACCESS_ADDNLINFO = "Additional Information"  ' IWizAccess97AdditionalInfo.htm
Const WIZPANEL_ACCESS_WKGRPFILE = "Workgroup File"          ' IWizAccess97WorkgroupFile.htm
Const WIZPANEL_ACCESS_SUMMARY   = "Summary"                 ' IWizAccess97Summary.htm

Const WIZPANEL_ACCESS2000_WELCOME   = "Welcome"
Const WIZPANEL_ACCESS2000_REDISTPATH  = "Redistributable Path"
Const WIZPANEL_ACCESS2000_BUILDDIR  = "Build Location"
Const WIZPANEL_ACCESS2000_SUMMARY   = "Summary"

Public Const CW_TYPE_COM_NEXT = "<br><br>After you select this component type and click the Next button, you will continue with the <a href='IWPComponentCOMStart.htm'>COM Server Executable</a> panel."
Public Const CW_TYPE_CTRLNTSRV_NEXT = "<br><br>After you select this component type and click the Next button, you will continue with the <a href='IWPComponentCtrlSvcSpecify.htm'>Specify Service</a> panel."
Public Const CW_TYPE_ODBC_NEXT = "<br><br>After you select this component type and click the Next button, you will continue with the <a href='IWPComponentODBCDriver.htm'>Specify ODBC Drivers</a> panel."
Public Const CW_TYPE_NTSERV_NEXT = "<br><br>After you select this component type and click the Next button, you will continue with the <a href='IWPComponentNTSvcStart.htm'>NT Service Executable</a> panel."
Public Const CW_TYPE_FONTS_NEXT = "<br><br>After you select this component type and click the Next button, you will continue with the <a href='IWPComponentFontSpecify.htm'>Add Installed Fonts</a> panel."

Public Const ACTIONS_STANDARD_TITLE = " Standard Actions"
Public Const ACTIONS_STANDARD_TEXT = "<p>Standard actions are those actions that are built into Windows Installer.  These actions are already inserted into the sequences and provide predefined functionality.  For example, the InstallFiles action copies files from the source media and places them in the destination folder.  The behavior of these actions cannot be altered.</p>" 

Public Const ACTIONS_CUSTOM_TITLE = " Custom Actions"
Public Const ACTIONS_CUSTOM_TEXT = "<p>With custom actions you can add specific functionality to your setup.  For example, you can call a function in a DLL; run JScript, VBScript, or InstallScript; or launch an EXE during your setup.</p>"

Public Const ACTIONS_VB_TITLE = " VB Scripts"
Public Const ACTIONS_VB_TEXT = "<p>Rather than calling a function from a DLL or launching an EXE as your custom action, you can use VB script to initiate your action.  This method may be easier if you aren't familiar with a more in-depth programming languages.  Another advantage of using VB script over a language such as C is that you don't have to compile a DLL or EXE in order to use the script.</p>"

Public Const ACTIONS_JAVA_TITLE = " Java Scripts"
Public Const ACTIONS_JAVA_TEXT = "<p>Like VBScript, JScript can be used to initiate your custom action.  These scripts can be used to launch readme files or executable files, just to name a few.</p>"

Public Const ACTIONS_IS_TITLE = " InstallScript"
Public Const ACTIONS_IS_TEXT = "<p><a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpISCriptOverview.htm"")'>InstallScript</a> provides users of previous versions of InstallShield the opportunity to use a familiar scripting language. Instead of having to author new DLLs or EXEs for custom actions, you can leverage the power and ease of InstallScript to extend the functionality of your Windows Installer package.</p> <p>With some exceptions, you can reuse code from existing InstallShield Professional scripts.  InstallShield Professional&mdash;Windows Installer Edition supports a slightly modified version of InstallScript tailored to the requirements of Windows Installer. To import an existing InstallScript file into your projectClick on InstallScript in the Actions/Scripts explorer, right-click in the file list, and select Insert Script Files.</p><p>Select InstallScript in the Actions/Scripts explorer to view all of your script files. To start a new script or include file, right-click in the file list and select New Script file. You must have a file called Setup.rul, which contains the prototype of your entry-point function. </p><p>Double-click on InstallScript to view all of the user-defined functions in your scripts.</p><p>Once you've written your script, you must create a custom action for it and then execute the custom action in your setup.  To create a custom action, right-click on Custom Actions and select <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpInsertCA.htm"")'>Custom Action Wizard</a>. Be sure to select &ldquo;Run InstallScript code&rdquo; in the Action Type panel. To execute the custom action, insert it into one of your project's sequences or select it as the result of a dialog's control event.</p>"

Public Const ACTIONS_SETUPFILES_TITLE = " Setup Files"
Public Const ACTIONS_SETUPFILES_TEXT = "<p>Setup files are files that are used in your custom actions, but are not installed to the end user's machine.  These files may include images, executables, or readme files.</p>"

Public Const PROJECT_PROJECTPROPERTIES_TITLE = " Project Properties"
Public Const PROJECT_PROJECTPROPERTIES_TEXT = "<p>The first thing you must do with any new setup project is enter its properties.&nbsp;Select the Properties item in the tree view to edit the properties.</p><P><table><tr valign='top'><td><img src='logo.gif' width='64' height='66'></td><td><p>Make sure that you fill in correct values for all of the properties. These properties are later used for registering your application according to Windows logo guidelines.</p></td></tr></table></p>"

Public Const PROJECT_PRODUCTPROPERTIES_TITLE = " Product Properties"
Public Const PROJECT_PRODUCTPROPERTIES_TEXT = "<p>A product is the highest level of organization in your setup project.  A default product is created for you when you start a new setup project.</p><p>You must set the product properties before you proceed. To set product properties, select your product in the tree control.  Its property sheet opens to the right. Then, click on a property to edit it.</p> <p>More help is available in the IDE for each property.</p>"

Public Const PROJECT_SIS_TITLE = " Summary Information Stream"
Public Const PROJECT_SIS_TEXT = "<p>The Summary Information Stream view allows you to supply summary information about your product.  This information can be accessed by right-clicking on your setup package and selecting Properties.  Then, click the Summary tab to view the summary information.  You will need to provide valid information in these fields in order to achieve Windows logo compliance.</p>"

Public Const PROJECT_WIN2KARP_TITLE = " Windows 2000"
Public Const PROJECT_WIN2KARP_TEXT = "<p>The Add/Remove Programs panel on Windows 2000 provides greater functionality and information for your users than has been available in previous versions of Windows.  By clicking one button, your users can remove, repair, or change the features selected for installation.  Additionally, your users can obtain information about your company, technical support, and product updates.  Many of these values must be set in order to achieve Windows logo compliance.</p>"

Public Const PROJECT_PATHVARIABLES_TITLE = " Path Variables"
Public Const PROJECT_PATHVARIABLES_TEXT = "<p>Path variables allow you to define commonly used paths in a central location so that you don't need to change every file's path each time you move the project or change the directory structure.  Click the Path Variables folder on the Project explorer for more information on Path Variables.</p>"

Public Const PROJECT_PROPMANAGER_TITLE = " Property Manager"
Public Const PROJECT_PROPMANAGER_TEXT = "<p>The Property Manager allows you to define project-wide properties for such things as font sizes in dialog boxes.  These properties can then be called throughout the IDE.  The advantage of using project-wide properties is that they can be changed in one location, rather than having to change it everywhere.</p>" 

Public Const PROJECT_STRINGTABLE_TITLE = " String Tables"
Public Const PROJECT_STRINGTABLE_TEXT = "<p>The String Table editor provides a single location for storing, creating, and editing strings used throughout your project.  <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpStringTables.htm"")'>String tables</a> are especially useful if you plan to localize your setup into other languages.  You can export your strings, send them to a translator, and then import them back into your setup project.</p>"

Public Const COM_HELP_COMCLASS   = "<p>Right-click on COM Classes in the COM Registration Explorer to register a class ID when this component is installed. </p><p>The name you give the COM class item in the tree will be registered as the default value under HKEY_CLASSES_ROOT\CLSID\&lt;GUID&gt;.  To give the class a new name, right-click on it and select Rename.</p><p>Next, click on the COM class to set its properties.</p><p>Finally, specify a context type for this class. The following list tells you which server context is appropriate for which type of COM server: <ul><li>LocalServer32&mdash;32-bit EXE</li><li>LocalServer&mdash;16-bit EXE</li><li>InprocServer32&mdash;32-bit DLL or OCX</li><li>InprocServer&mdash;16-bit DLL or OCX</li></ul></p><p>If the server context is LocalServer or LocalServer32, click on the context to set the Default Inproc Handler and Argument properties. </p>"
Public Const COM_HELP_PROGID     = "<p>Right-click on ProgIDs to specify a new programmatic identifier for this COM server.</p><p>A progID is a string used to identify a class in the format <i>Component.Class.N</i>.  To give the progID a new name, right-click and select Rename.</p><p>Click on the progID to set its properties.</p>"
Public Const COM_HELP_VIPID      = "<p>Right-click on Version-Independent ProgIDs to specify a new version-independent programmatic identifier for this COM server.</p><p>A version-independent progID is a string used to identify a class in the format <i>Component.Class</i>, which is constant for all versions of a class.  To give the version-independent progID a new name, right-click and select Rename.</p><p>Click on the version-independent progID to set its properties.</p>"
Public Const COM_HELP_TYPELIB    = "<p>Right-click on Type Libraries to specify the type libraries, or libIDs, referenced by this COM server.  </p><p>The name you give the type library item is registered as the default value under HKEY_CLASSES_ROOT\TypeLib\&lt;libID&gt;\&lt;version&gt;. To give the type library item a new name, right-click and select Rename.</p><p>Click on the type library to set its properties.</p>"
Public Const COM_HELP_APPID      = "<p>Right-click on AppIDs to specify a new application identifier for this DCOM file. Give the appID any name you'd like. It will not be registered; the name is merely a way for you to refer to the appIDs in your project.</p><p>An appID is a GUID registered under HKEY_CLASSES_ROOT\AppID used for grouping all of the security and configuration options of distributed COM objects. </p><p>Click on the appID to set its properties.</p>"

Public Const IHELP_UIVIEW_ADDDIALOG_TITLE = " Add a New Dialog to the Project"
Public Const IHELP_UIVIEW_ADDDIALOG_TEXT = "<p>To create a dialog from scratch, right-click on the All Dialogs folder and select New Dialog.  InstallShield will prompt you for information and then add an item for the new dialog under All Dialogs.  The next step is to edit the dialog's layout in the <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpEUDialogsEditLayout.htm"")'>Dialog editor</a> and the controls' behavior in the <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpEUDialogsEditBehavior.htm"")'>Behavior editor</a>.</p><p>You can also add a dialog by importing one from another project (see below). </p><p>Adding a dialog to a project does not mean that the dialog will be displayed in the setup. <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpEUDialogsInsertIntoSequence.htm"")'>To display a dialog</a>, you must add it to a sequence or launch it as the result of a dialog's control event. </p>"

Public Const IHELP_UIVIEW_ADDDIALOG_TEXT_MM = "<p>To create a dialog from scratch, right-click on the All Dialogs folder and select New Dialog.  InstallShield will prompt you for information and then add an item for the new dialog under All Dialogs.  The next step is to edit the dialog's layout in the Dialog editor and the controls' behavior in the Behavior editor.  </p><p>You can also add a dialog by importing one from another project.  To export a dialog to a file, right-click on a language-specific version of the dialog in the User Interface explorer and select Export Dialog.  Then, to add the dialog to this project, right-click on the All Dialogs folder and select Import Dialog.  </p><p>Adding a dialog to a project does not mean that the dialog will be displayed in the setup.  When you create a dialog in a merge module project, you cannot add that dialog to a sequence until you've associated your module with a setup project."

Public Const IHELP_UIVIEW_EXPORTDIALOG_TITLE = " Export Dialogs for Use in Another Project"
Public Const IHELP_UIVIEW_EXPORTDIALOG_TEXT  = "<p>You can export dialogs to an <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpEUDialogsExport.htm"")'>InstallShield dialog (.isd) file</a>, to a standard <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpEUDialogsExportRC.htm"")'>resource script (.rc) file</a>, or directly to <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpEUDialogsExportIsm.htm"")'>another project</a>.</p>"
Public Const IHELP_UIVIEW_IMPORTDIALOG_TITLE = " Import Dialogs from Another Project"
Public Const IHELP_UIVIEW_IMPORTDIALOG_TEXT  = "<p>To import an .isd file (see above), right-click on the All Dialogs folder and select Import Dialog to copy the dialog to the current project.  </p><p>To import all of the dialog resources from a DLL, right-click on All Dialogs and select &ldquo;Import Dialogs from Resource DLL.&rdquo;</p>"
Public Const IHELP_UIVIEW_REMOVEDIALOG_TITLE = " Remove a Dialog from the Project"
Public Const IHELP_UIVIEW_REMOVEDIALOG_TEXT  = "<p>Right-click on a dialog and select Delete to permanently remove the dialog from your project.  Note that right-clicking on a dialog in the Sequences explorer and selecting Remove does not delete the dialog from your project;  it merely removes it from that sequence.  </p>"
Public Const IHELP_UIVIEW_REMOVEDIALOG_TEXT2 = "<p>Right-click on a dialog and select Delete to permanently remove the dialog from your project.</p>"
Public Const IHELP_UIVIEW_RENAMEDIALOG_TITLE = " Rename a Dialog"
Public Const IHELP_UIVIEW_RENAMEDIALOG_TEXT  = "<p>Right-click on a dialog and select Rename to give it a new name.</p>"
Public Const IHELP_UIVIEW_ADDLANG_TITLE = " Add a Version of the Dialog for an Additional Language"
Public Const IHELP_UIVIEW_ADDLANG_TEXT  = "<p>Whenever you <a href='#' onclick='JavaScript:OpenHelpToTopic (""IHelpProjLangs.htm"")'>add support for a language</a> to your project, InstallShield adds a version of each default dialog for the new language.  The copies for each language contain fully translated strings and resources. </p> <p>Likewise, when you create your own dialog, InstallShield makes a copy for each language your setup is targeting. However, it is your responsibility to <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpGlobDialogs.htm"")'>modify the dialog for each language</a>.</p> <p><table><tr><td valign='top'><img src='tip.gif'></td><td>Be careful when making language-specific changes to a dialog's layout.  As long as you resize or otherwise modify the resources for only the <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpGlobDefLang.htm"")'>default language's</a> version of the dialog, those changes will apply to every language-specific version of the dialog.  But once you modify the layout for a dialog in a language other than the default, that connection is broken, which means that the changes apply only to the current language's version of the dialog and changes to the default language's version no longer affect the modified language-specific version.  <br><br>Suppose that English were your default language and you added a text object to the English version of the dialog.  Now the English and the German versions of the dialog share the same control and properties, such as the Text property, which uses a string ID instead of a hard-coded string, and the Height and Width properties.  When you go to look at the German version, you notice that the size is not big enough for the German string so you resize the text object.  At this point, the entire German dialog resource is separate from the English version.  If, for example, you wanted to change the control's string ID, you would have to make the same change to both versions of the dialog.  In this case, it might have been better just to resize the area in the English version in order to maintain uniformity and ease of maintenance between the dialogs. </td></table> </tr> </p>"
Public Const  IHELP_UIVIEW_BEHAVIOR_TITLE = " Edit the Behavior of a Dialog's Controls"
Public Const  IHELP_UIVIEW_BEHAVIOR_TEXT  = "<p>Select the Behavior item under the dialog in the User Interface explorer to launch the Behavior editor.  Click on a control in the editor to modify its Events, Subscriptions, and Conditions.</p>"
Public Const IHELP_UIVIEW_EDITDLG_TITLE = " Edit the Dialog's Layout"
Public Const IHELP_UIVIEW_EDITDLG_TEXT  = "<p>You can open a dialog in the Dialog editor in any of the following ways:</p><ul> <li>Select the language-specific version of the dialog under the dialog's name in the User Interface explorer. </li><li>Select the dialog's name in the User Interface explorer. In the pane to the right under the Action Items heading, select a language from the drop-down list and click the &ldquo;Edit this dialog layout&rdquo; link. </li></ul><p>The Dialog editor opens in the right pane of the User Interface explorer, and now you can <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpEUDialogsEditLayout.htm"")'>edit</a> any control or property of the dialog you selected.  </p><p>The default dialogs that InstallShield provides are populated with controls and with information provided by you elsewhere in the IDE and stored in <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpCreateChangeProperty.htm"")'>Windows Installer properties</a>.  Using the Dialog editor, you can edit these controls or new ones you've drawn on the dialog and their properties.  </p><p>The next step is to go to the Behavior editor to modify the events, subscriptions, and conditions for the dialog.  </p>"

Public Const IHELP_DEMOS_FEATURENAME_DEMOS = "Demos"   ' Internal name of demos feature
Public Const IHELP_DEMOS_FEATURENAME_BESTPRACTICES = "BestPractices" ' Internal name of Best Practices subfeature
Public Const IHELP_DEMOS_FEATURENAME_SHORTCUTS = "Shortcuts" ' Internal name of Best Practices subfeature
Public Const IHELP_DEMOS_PROMPTTEXT  = "This demo has not yet been installed.  Do you want to install its feature so you can view the demo?"
Public Const IHELP_DEMOS_FEATURENAME_CONTROLNTSERVICES = "ControlNTServices" ' Internal name of Control NT Services subfeature
Public Const IHELP_DEMOS_FEATURENAME_INSTALLNTSERVICES = "InstallNTServices" ' Internal name of Install NT Services subfeature
Public Const IHELP_DEMOS_FEATURENAME_SETUPDESIGN = "SetupDesign" ' Internal name of Setup Design subfeature
Public Const IHELP_DEMOS_FEATURENAME_FILETYPES = "FileTypes" ' Internal name of FileTypes subfeature
Public Const IHELP_DEMOS_FEATURENAME_COMSERVER = "RegisterComServer" ' Internal name of COM Server subfeature
Public Const IHELP_DEMOS_FEATURENAME_DIALOGEDITOR = "DialogEditor" ' Internal name of Dialog Editor subfeature
Public Const IHELP_DEMOS_FEATURENAME_MERGEMODULES = "MergeModules"
Public Const IHELP_DEMOS_FEATURENAME_PATHVARIABLES = "PathVariables"
Public Const IHELP_DEMOS_FEATURENAME_CUSTOMACTIONS = "CustomActions"

Public Const IHELP_GLOSSARY_TOOLTIP = "Click to show or hide all the definitions for this letter."

Public Const IHELP_EXSCRIPT_BUTTON_TOOLTIP = "Click here to see this function in an example script."

Public Const POPUP_TITLE_DESTINATION = "Data Type"

Public Const SETUPDESTINATION_ADDDESTINATION_TITLE = " Add a Destination"

Public Const SETUPDESTINATION_ADDDESTINATION_TEXT = "<p>To add a destination folder to your project, right-click on the Setup Design-Destination item and select New Destination Folder.  A new root destination will be created for you.  You can rename this destination by pressing the F2 key and typing a new name.  If you would like to use an entry from the Directory table, simply type in the name of the entry that you would like to use, enclosed in square brackets.  For example, if you want to create a destination folder for INSTALLDIR, enter [INSTALLDIR] for the folder's name.</p><p>To create a subfolder of an existing destination folder, right-click on the folder under which you would like your new one to be created and select New Destination Folder.</p><P><table><tr valign=top><td><IMG src='note.gif'></td><TD>When you create a subfolder, you cannot use Windows Installer <a href='#' onclick='JavaScript:OpenHelpToTopic (""IHelpPropReference.htm"")'>folder properties</a>.  Instead, you should use a Windows Installer folder property for the root folder.</TD></TR></TABLE></p><p>A destination folder has meaning only when a component's data are associated with it. For that reason, InstallShield removes folders that have no components attached to them once the view is refreshed. </p>"

Public Const SETUPDESTINATION_CHANGEDESTINATION_TITLE = " Change a Destination Folder"

Public Const SETUPDESTINATION_CHANGEDESTINATION_TEXT = "<p>Through the Destination view you can change the destination of any component in your setup, excluding those imported within a merge module.  To change the destination of a component, drag it to the folder under which you would like it to reside.  Alternatively, you can right-click on a component and select Move Up, Move Down, Move Right, or Move Left.  The same actions will move a subfolder destination and all of its contents.  However, if you would like to change the destination of a root folder, you will need to change the name of the folder to a different Windows Installer folder property. Additionally, you can always change the destination of any component from the Setup Design or the Components views.</p>"

Public Const SETUPDESTINATION_VIEWFILES_TITLE = " View the Files Associated with Each Destination"

Public Const SETUPDESTINATION_VIEWFILES_TEXT = "<p>To view all the files that will be installed to a specific folder, simply navigate to that folder on the Destination explorer. All the files stored within components that are directly under that folder will be displayed, as will all the subfolders of the current folder.  To view all the files that will be installed with a certain component, navigate to that component on the Destination explorer.</p>"

Const IHELP_EXSCRIPT_WINDOW_TITLE = "Example Script"

Const IHELP_EXSCRIPT_WINDOW_HASH = "#Outside" ' Do NOT translate

Const IHELP_UNSUPPFN_FORMAT_BEGIN = "<table width='100%' border='8' bordercolor='yellow' cellpadding='5' style='border-style: solid'><tr><td>"
Const IHELP_UNSUPPFN_FORMAT_END = "</td></tr></table><br>"
Const IHELP_UNSUPPFN_TEXT = "This function is not available in InstallShield Professional&mdash;Windows Installer Edition.  This documentation is maintained as a service for customers who have legacy scripts that call this function. For detailed information about InstallScript in this version of InstallShield, see <a href='#' onclick='ShowSupportedPage()'>Supported Functions and Event Handlers</a>."
Const IHELP_UNSUPPFN_RETURN = "<br><br>Click <a href='VBScript:window.history.back'>here</a> to return to the last topic you visited."
Const IHELP_UNSUPPEVENT_TEXT = "Only the <a href='LangrefOnBegin.htm'>OnBegin</a>, <a href='LangrefOnEnd.htm'>OnEnd</a>, <a href='LangrefOnHelp.htm'>OnHelp</a>, and <a href='LangrefOnCanceling.htm'>OnCanceling</a> event handlers are available in InstallShield Professional&mdash;Windows Installer Edition.  This documentation is maintained as a service for customers with legacy scripts. For detailed information about InstallScript in this version of InstallShield, see <a href='HelpLib.chm::/IHelpIScriptSupportedFns.htm'>Supported Functions and Event Handlers</a>."
Const IHELP_UNSUPPFUNCTIONS_TEXT = "These functions are not available in InstallShield Professional&mdash;Windows Installer Edition.  This documentation is maintained as a service for customers who have legacy scripts that call these functions. For detailed information about InstallScript in this version of InstallShield, see <a href='#' onclick='ShowSupportedPage()'>Supported Functions and Event Handlers</a>."
Const IHELP_UNSUPPSYSVARS_TEXT = "This system variable is not available in InstallShield Professional&mdash;Windows Installer Edition.  This documentation is maintained as a service for customers who have legacy scripts that use this variable. For detailed information about InstallScript in this version of InstallShield, see <a href='#' onclick='ShowSupportedPage()'>Supported Functions and Event Handlers</a>."

Const ISX_BUILD_MEDIA_TITLE = "&nbsp;Select Media Type"
Const ISX_BUILD_MEDIA_TEXT =  "<p>The first step in building your setup is to choose the type of media on which you are distributing your setup.  The Build Your Release view offers six predefined <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpISXBuildMediaType.htm"")'>media types</a>, as well as a custom type you can tailor to meet additional requirements. Before you can build a release, you must select a media type and set its properties. </p>"

Const ISX_BUILD_PROPERTIES_TEXT = "<p>Build <a href='#' onclick='JavaScript:OpenHelpToTopic(""IHelpISXBuildProperties.htm"")'>properties</a> allow you to further customize your release.  With these properties you can include Setup.exe to install Windows Installer on supported platforms, or compress your setup into one file, just to name a few of the options. "
Const ISX_BUILD_PROPERTIES_TITLE = "&nbsp;Set Build Properties"

Const ISX_BUILD_BUILD_TITLE = "&nbsp;Build"
Const ISX_BUILD_BUILD_TEXT ="<p>To build your setup, right-click on a media type and select Build.  The Output window opens at the bottom of your screen, displaying the build's status.  Once your build is complete, you can view the log file by expanding the tree under the release you just built and clicking on the Logs item. </p>"

Const IHELP_OPTIONTEXT_0 = "Launch an executable"
Const IHELP_OPTIONTEXT_1 = "Call a function in a standard dynamic-link library"
Const IHELP_OPTIONTEXT_2 = "Call a function in a Windows Installer dynamic-link library"
Const IHELP_OPTIONTEXT_3 = "Run VBScript code"
Const IHELP_OPTIONTEXT_4 = "Run JScript code"
Const IHELP_OPTIONTEXT_5 = "Run InstallScript code"
Const IHELP_OPTIONTEXT_6 = "Set a property"
Const IHELP_OPTIONTEXT_7 = "Set a directory"
Const IHELP_OPTIONTEXT_8 = "Launch a second .msi package"

Const IHELP_ACCESS97_VS_2000_TITLE = " Access 97 vs. Access 2000"
Const IHELP_ACCESS97_VS_2000_TEXT  = "<p>Installing the Access 97 run-time files on a system that already has Access 2000 can cause problems for your application, as can installing Access 2000 after your Access 97 application has been installed.  One potential problem that you need not worry about is the fact that the Access 97 run-time files will not be installed over the Access 2000 run-time files, and vice-versa.  The Access 97 run-time files are installed to &lt;ProgramFilesFolder&gt;\Microsoft Office\Access 97, by default.</p> <p>One problem that can occur as a result of installing Access 97 over Access 2000 is that Access 2000 will try to repair itself every time it is run.  This repair process will break your Access 97 run-time installation, requiring your end users to run your setup in repair mode in order to regain the proper functionality.  The same problem can occur if Access 2000 is removed after the Access 97 run-time files have been installed.</p> <p>A second problem that can occur as a result of having both Access 97 and Access 2000 on the same machine comes from not making use of the <tt>/wrkgrp</tt> command-line option in a shortcut. If you decide not to use the <tt>/wrkgrp</tt> option, your Access 97 application may have trouble finding System.mdw after Access 2000 runs. To avoid this problem, specify <tt>/wrkgrp</tt> at the command line or in the shortcut's target and point to the .mdw file you want your application to use.</p>"

Const WIZPANEL_BDE_WELCOME = "Welcome"  'IWizBDEMMWelcome.htm
Const WIZPANEL_BDE_INIFILE = "INI File Location"    'IWizBDEMMINIFile.htm
Const WIZPANEL_BDE_CONFIGUREINIFILE = "Configure INI File"  'IWizBDEMMConfigureINIFile.htm
Const WIZPANEL_BDE_UTILITY = "BDE Merge Module Configuration Utility"   'IWizBDEMMUtility.htm
Const WIZPANEL_BDE_ADDALIAS = "Add Alias"   'IWizBDEMMAddAlias.htm
Const WIZPANEL_BDE_SUMMARY = "Summary"  'IWizBDEMMSummary.htm

' -->